<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::post('/login', [\App\Http\Controllers\API\AuthController::class, 'login']);
Route::get('/test', function () {
    return response()->json(['message' => 'Test endpoint works!']);
});
Route::get('/settings', [\App\Http\Controllers\API\SettingsController::class, 'index']);

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\API\DashboardController::class, 'index']);
    Route::get('/orders', [\App\Http\Controllers\API\OrderController::class, 'index']);
    Route::post('/orders', [\App\Http\Controllers\API\OrderController::class, 'store']);
    Route::get('/orders/{id}', [\App\Http\Controllers\API\OrderController::class, 'show']);
    Route::patch('/orders/{id}/status', [\App\Http\Controllers\API\OrderController::class, 'updateStatus']);
    Route::delete('/orders/{id}', [\App\Http\Controllers\API\OrderController::class, 'destroy']);
    Route::get('/services', [\App\Http\Controllers\API\ServiceController::class, 'index']);
    Route::get('/services/{id}', [\App\Http\Controllers\API\ServiceController::class, 'show']);
    Route::get('/service-types', [\App\Http\Controllers\API\ServiceTypeController::class, 'index']);
    Route::get('/service-types/{id}', [\App\Http\Controllers\API\ServiceTypeController::class, 'show']);
    Route::get('/customers', [\App\Http\Controllers\API\CustomerController::class, 'index']);
    Route::post('/customers', [\App\Http\Controllers\API\CustomerController::class, 'store']);
    Route::post('/payments', [\App\Http\Controllers\API\PaymentController::class, 'store']);
});

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');
