<div class="dashboard-main-body-custom">
    <!-- Menggunakan Bootstrap 5 untuk Layout sesuai request User - Di-inject Paksa -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
    <style>
        /* Fix Bootstrap Global Link Style Override */
    a { text-decoration: none !important; }

    /* Scoped styles to ensure the report looks exactly as requested */
        /* Force override parent styles if any */
        .dashboard-main-body-custom {
            background-color: #f4f6f8;
            padding: 20px;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            border-radius: 1rem;
            width: 100%;
        }

        /* Styles Custom dari kode asli User */
        .dashboard-main-body-custom .rounded-4 { border-radius: 1rem !important; }
        .dashboard-main-body-custom .text-sm { font-size: 0.875rem; }
        .dashboard-main-body-custom .fs-1 { font-size: 2.5rem; }
        
        /* Hover Effects */
        .dashboard-main-body-custom .btn-outline-primary { transition: all 0.2s; }
        .dashboard-main-body-custom .btn-outline-primary:hover { transform: translateY(-1px); box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        
        /* Simulasi Card Gradient */
        .dashboard-main-body-custom .bg-gradient-primary {
            background: linear-gradient(135deg, #0d6efd 0%, #0a58ca 100%) !important;
        }

        .dashboard-main-body-custom .shadow-sm {
            box-shadow: 0 .125rem .25rem rgba(0,0,0,.075)!important;
        }

        /* Print Setup */
        @media print {
            body { background: white !important; }
            .dashboard-main-body-custom { margin: 0; padding: 0; background: white; width: 100%; max-width: none; }
            .d-none-print, .btn, select, .card-footer, .no-print { display: none !important; }
            .card { border: 1px solid #ddd !important; box-shadow: none !important; break-inside: avoid; }
            .text-white { color: black !important; }
            .bg-gradient-primary { background: white !important; color: black !important; border: 2px solid #000; }
            .bg-light { background: white !important; }
        }
    </style>
    
    <!-- Header Section -->
    <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3 mb-4">
        <div>
            <h4 class="fw-bold text-dark mb-1">Financial Overview</h4>
            <p class="text-muted text-sm mb-0">
                Laporan Keuangan Periode <span class="fw-bold text-primary">{{ date('F', mktime(0, 0, 0, $month, 1)) }} {{ $year }}</span>
            </p>
        </div>
        
        <!-- Filter Tools -->
        <div class="d-flex align-items-center gap-2 bg-white p-2 rounded-3 shadow-sm border">
             <select class="form-select form-select-sm border-0 bg-light fw-bold text-dark" style="width: 130px; cursor: pointer;" wire:model.live="month">
                @foreach(range(1, 12) as $m)
                    <option value="{{ $m }}">{{ date('F', mktime(0, 0, 0, $m, 1)) }}</option>
                @endforeach
             </select>
             <select class="form-select form-select-sm border-0 bg-light fw-bold text-dark" style="width: 100px; cursor: pointer;" wire:model.live="year">
                @foreach(range(2023, date('Y') + 10) as $y)
                    <option value="{{ $y }}">{{ $y }}</option>
                @endforeach
             </select>
             <div class="vr mx-1 opacity-25"></div>
             <button onclick="window.print()" class="btn btn-dark btn-sm d-flex align-items-center gap-2 px-3">
                 <iconify-icon icon="solar:printer-bold"></iconify-icon>
                 Print
             </button>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <!-- Left Side: Main Stats -->
        <div class="col-lg-8">
            <!-- Hero Card: Net Income -->
            <div class="card border-0 rounded-4 shadow-sm mb-4 position-relative overflow-hidden bg-gradient-primary">
                <div class="card-body p-4 p-md-5 d-flex align-items-center justify-content-between position-relative z-1">
                    <div>
                        <div class="d-flex align-items-center gap-2 mb-2 text-white-50">
                            <iconify-icon icon="solar:verified-check-bold" class="text-white"></iconify-icon>
                            <span class="text-uppercase fw-bold" style="font-size: 12px; letter-spacing: 1px;">Net Profit (Bersih)</span>
                        </div>
                        <h1 class="fw-bold text-white mb-2" style="font-size: 3.8rem !important;">{{ getFormattedCurrency($total_net_income) }}</h1>
                        <p class="text-white text-opacity-75 mb-0 text-sm">Total keuntungan bersih setelah dikurangi pengeluaran & pajak.</p>
                    </div>
                    <div class="d-none d-md-block text-white opacity-25">
                        <iconify-icon icon="solar:chart-square-bold" style="font-size: 5rem;"></iconify-icon>
                    </div>
                </div>
                <!-- Subtle Pattern Overlay -->
                <div class="position-absolute top-0 end-0 h-100 w-50" style="background: radial-gradient(circle at top right, rgba(255,255,255,0.1), transparent 70%);"></div>
            </div>

            <!-- Secondary Stats Grid -->
            <div class="row g-4">
                <!-- Gross Income -->
                <div class="col-md-6">
                    <div class="card h-100 border-0 rounded-4 shadow-sm">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="bg-primary bg-opacity-10 text-primary p-3 rounded-3">
                                    <iconify-icon icon="solar:wallet-money-bold" class="fs-4 d-block"></iconify-icon>
                                </div>
                                <span class="badge bg-light text-secondary border">Income</span>
                            </div>
                            <h4 class="fw-bold text-dark mb-1">{{ getFormattedCurrency($total_gross_income) }}</h4>
                            <span class="text-secondary text-sm">Total Pendapatan Kotor</span>
                        </div>
                    </div>
                </div>

                <!-- Expense -->
                <div class="col-md-6">
                    <div class="card h-100 border-0 rounded-4 shadow-sm">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="bg-warning bg-opacity-10 text-warning p-3 rounded-3">
                                    <iconify-icon icon="solar:bill-list-bold" class="fs-4 d-block"></iconify-icon>
                                </div>
                                <span class="badge bg-light text-secondary border">Expense</span>
                            </div>
                            <h4 class="fw-bold text-dark mb-1">{{ getFormattedCurrency($total_expense) }}</h4>
                            <span class="text-secondary text-sm">Total Pengeluaran</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Side: Summary & Orders -->
        <div class="col-lg-4">
            <div class="card border-0 rounded-4 shadow-sm h-100">
                <div class="card-header bg-transparent border-bottom p-4">
                    <h5 class="fw-bold mb-0">Rincian Laporan</h5>
                </div>
                <div class="card-body p-0">
                    <!-- Orders Highlight -->
                    <div class="p-4 bg-light border-bottom">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <span class="text-secondary fw-bold text-uppercase" style="font-size: 11px;">Total Transaksi</span>
                                <h3 class="fw-bold text-dark mb-0 mt-1">{{ $total_orders }}</h3>
                            </div>
                            <div class="text-success">
                                <iconify-icon icon="solar:bag-smile-bold" class="fs-1 opacity-50"></iconify-icon>
                            </div>
                        </div>
                    </div>

                    <!-- Financial Breakdown Table -->
                    <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <tbody>
                                <tr>
                                    <td class="px-4 py-3 text-secondary fw-medium">Gross Income</td>
                                    <td class="px-4 py-3 text-end fw-bold text-dark">{{ getFormattedCurrency($total_gross_income) }}</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-3 text-secondary fw-medium">Operational Cost</td>
                                    <td class="px-4 py-3 text-end fw-bold text-danger">- {{ getFormattedCurrency($total_expense) }}</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-3 text-secondary fw-medium">Tax (Est.)</td>
                                    <td class="px-4 py-3 text-end fw-bold text-danger">- {{ getFormattedCurrency($total_tax) }}</td>
                                </tr>
                                <tr class="bg-success bg-opacity-10">
                                    <td class="px-4 py-4 fw-bold text-success">
                                        <div class="d-flex align-items-center gap-2">
                                            Net Profit
                                            <iconify-icon icon="solar:info-circle-bold" class="small"></iconify-icon>
                                        </div>
                                    </td>
                                    <td class="px-4 py-4 text-end fw-bolder text-success mb-0" style="font-size: 1.1rem;">{{ getFormattedCurrency($total_net_income) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-transparent p-4 border-top-0">
                    <button class="btn btn-outline-primary w-100 rounded-3 d-flex justify-content-center align-items-center gap-2">
                        <iconify-icon icon="solar:file-download-bold"></iconify-icon>
                        Download PDF Report
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>