<div class="dashboard-main-body">
    <div class="tw-flex tw-gap-4 lg:tw-flex-row tw-flex-col">
        <div class="card h-100 p-0 radius-12 tw-w-full">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center flex-wrap gap-3 justify-content-between ">
                <div class="tw-flex tw-flex-col  tw-text-sm">
                    <div class="text-lg tw-font-medium text-primary-light">
                        {{ $sitename }}
                    </div>
                    <div class="tw-flex tw-flex-col tw-mt-2">
                        <div class="">{{$phone ? getCountryCode() : ''}}{{ (int)$phone }}</div>
                        <div class="">{{ $store_email }}</div>
                        <div class="">{{ $address }} - {{ $zipcode }}</div>
    
                        <div class="tw-mt-2">{{ $lang->data['tax'] ?? 'TAX' }}: {{ $tax_number }}</div>
                    </div>
                </div>
                <div class="tw-flex tw-flex-col  tw-text-sm tw-items-end">
                    <div class="text-lg tw-font-medium text-primary-light">
                    </div>
                    <div class="tw-flex tw-flex-col tw-mt-2 tw-items-end">
                        <div class="text-neutral-600">
                            {{ $lang->data['order_id'] ?? 'Order ID' }} : <span class="tw-font-medium text-primary-light">#{{ $order->order_number }}</span> 
                        </div>
                        <div class="text-neutral-600">
                            {{ $lang->data['order_date'] ?? 'Order Date' }} : <span class="tw-font-medium text-primary-light">{{ \Carbon\Carbon::parse($order->order_date)->format('d/m/Y') }}</span> 
                        </div>
                        <div class="text-neutral-600">
                            {{ $lang->data['delivery_date'] ?? 'Delivery Date' }} : <span class="tw-font-medium text-primary-light">{{ \Carbon\Carbon::parse($order->delivery_date)->format('d/m/Y') }}</span> 
                        </div>
                        <div class="tw-mt-2 tw-flex tw-items-center tw-gap-2">
                            <div class="">
                                {{ $lang->data['order_status'] ?? 'Order Status' }} : 
                            </div>
                            <div class="dropdown">
                                @can('order_status_change')
                                @if($order->status != 3 && $order->status != 4)
                                <button class="btn btn-primary-600 not-active tw-py-1 tw-px-2 dropdown-toggle toggle-icon" type="button" data-bs-toggle="dropdown" aria-expanded="false"> {{ getOrderStatus($order->status) }} </button>
                                <ul class="dropdown-menu" style="">
                                  <li><a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900" href="#" wire:click.prevent="changeStatus(1)">{{ $lang->data['processing'] ?? 'Processing' }}</a></li>
                                  <li><a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900" href="#" wire:click.prevent="changeStatus(2)">{{ $lang->data['ready_to_deliver'] ?? 'Ready To Deliver' }}</a></li>
                                  <li>
                                        @if($balance > 0)
                                        <button disabled class="dropdown-item px-16 py-8 rounded tw-text-neutral-400  disabled:tw-bg-transparent" href="#" >
                                            {{ $lang->data['delivered'] ?? 'Delivered' }} <span class="text-danger text-xs">({{ $lang->data['payment_incomplete'] ?? 'Payment Incomplete' }})</span>
                                        </button>
                                        @else
                                        <button  class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900" href="#" wire:click.prevent="changeStatus(3)">
                                            {{ $lang->data['delivered'] ?? 'Delivered' }} 
                                        </button>
                                        @endif
                                    </li>
                                  <li><a class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900" href="#" wire:click.prevent="changeStatus(4)">{{ $lang->data['returned'] ?? 'Returned' }}</a></li>
                                </ul>
                                @else
                                    @if($order->status == 4)
                                    <div class="text-danger">
                                        {{ $lang->data['returned'] ?? 'Returned' }}
                                    </div>
                                    @else
                                    <div class="text-success">
                                        {{ $lang->data['delivered'] ?? 'Delivered' }}
                                    </div>
                                    @endif
                                @endif
                                @endcan
                                @cannot('order_status_change')
                                <div class="">
                                    {{ getOrderStatus($order->status) }}
                                </div>
                                @endcannot 
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body p-24">
                <div class="table-responsive scroll-sm">
                    <table class="table bordered-table sm-table mb-0">
                      <thead>
                        <tr>
                          <th scope="col" class="">#</th>
                          <th scope="col" class="">{{ $lang->data['service_name'] ?? 'Service Name' }}</th>
                          <th scope="col" class=""> {{ $lang->data['color'] ?? 'Color' }}</th>
                          <th scope="col" class="">{{ $lang->data['rate'] ?? 'Rate' }}</th>
                          <th scope="col" class=""> {{ $lang->data['qty'] ?? 'QTY' }}</th>
                          <th scope="col" class=""> {{ $lang->data['total'] ?? 'Total' }}</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach ($orderdetails as $item)
                            @php
                                $service = \App\Models\Service::where('id', $item->service_id)->first();
                            @endphp
                            <tr class="tw-text-sm">
                                <td>
                                    {{ $loop->index + 1 }}
                                </td>
                                <td class="">
                                    <div class="tw-flex tw-gap-4">
                                        <div class="tw-size-10">
                                            <img src="{{ asset('assets/img/service-icons/' . $service->icon) }}" class="tw-object-contain" alt="">
                                        </div>
                                        <div class="tw-flex tw-flex-col">
                                            <p class="tw-text-black">{{ $service->service_name }}</p>
                                            <p class="tw-text-gray-600 tw-text-xs">[{{$item->service_name}}]</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-primary">
                                    @if($item->color_code!="")
                                    <div class="tw-size-6 tw-rounded-lg" style="background-color: {{$item->color_code}}">
                                    </div>

                                    @else
                                    <div class="tw-size-6 tw-rounded-lg tw-bg-white" >
                                    </div>
                                    @endif
                                </td>
                                <td class="text-primary">
                                    {{ getFormattedCurrency($item->service_price) }}
                                </td>
                                <td>
                                    {{ $item->service_quantity }}
                                </td>
                                <td class="text-primary">
                                    {{ getFormattedCurrency($item->service_detail_total) }}
                                </td>
                               
                            </tr>
                            @endforeach
                      </tbody>
                    </table>
                </div>

                <div class="tw-flex tw-flex-col">
                    <div class="tw-flex tw-justify-between tw-items-start tw-mt-6">
                        <div class="tw-flex tw-flex-col ">
                            <div class="">{{ $lang->data['invoice_to'] ?? 'Invoice To' }}</div>
                            <div class="tw-mt-2 tw-font-medium tw-text-sm">
                                {{ $customer->name ?? 'Walk-In Customer' }}
                            </div>
                            <div class="tw-text-sm">
                                {{$customer && $customer->phone ? getCountryCode() : ''}} {{  $customer && $customer->phone ?  (int)$customer->phone : 'Phone' }}
                            </div>
                            <div class=" tw-text-sm">
                                {{ $customer->email ?? 'Email' }}
                            </div>
                            <div class=" tw-text-sm">
                                {{ $customer->address ?? '' }}
                            </div>
    
                            <div class="tw-text-sm tw-mt-2">
                                {{ $lang->data['vat'] ?? 'VAT' }} : {{ $customer->tax_number ?? 'TAX' }}
                            </div>
                        </div>
    
                        <div class="tw-flex tw-flex-col ">
                            <div class="pb-2">{{ $lang->data['payment_details'] ?? 'Payment Details' }}</div>
                            <div class="tw-flex tw-justify-between tw-items-center tw-w-[17rem] tw-mt-2">
                                <div class="  tw-text-sm">
                                    {{ $lang->data['sub_total'] ?? 'Sub Total' }}
                                </div>
                                <div class=" tw-text-sm">
                                    {{ getFormattedCurrency($order->sub_total) }}
                                </div>
                            </div>
                            <div class="tw-flex tw-justify-between tw-items-center tw-w-[17rem]">
                                <div class="  tw-text-sm">
                                    {{ $lang->data['addon'] ?? 'Addon' }}
                                </div>
                                <div class=" tw-text-sm">
                                    {{ getFormattedCurrency($order->addon_total) }}
                                </div>
                            </div>
                            <div class="tw-flex tw-justify-between tw-items-center tw-w-[17rem]">
                                <div class="  tw-text-sm">
                                    {{ $lang->data['discount'] ?? 'Discount' }}
                                </div>
                                <div class=" tw-text-sm">
                                    {{ getFormattedCurrency($order->discount) }}
                                </div>
                            </div>
                            <div class="tw-flex tw-justify-between tw-items-center tw-w-[17rem]">
                                <div class="  tw-text-sm">
                                    {{ $lang->data['tax'] ?? 'Tax' }}
                                        ({{ $order->tax_percentage }}%)
                                </div>
                                <div class=" tw-text-sm">
                                    {{ getFormattedCurrency($order->tax_amount) }}
                                </div>
                            </div>
                            <div class="tw-flex tw-justify-between tw-items-center tw-w-[17rem] tw-mt-2  ">
                                <div class=" tw-font-bold tw-text-sm">
                                    {{ $lang->data['gross_total'] ?? 'Gross Total' }}
                                </div>
                                <div class="tw-font-bold tw-text-sm">
                                    {{ getFormattedCurrency($order->total) }}
                                </div>
                            </div>
                           
                        </div>
                    </div>
                    <hr class="tw-mt-4">
                    <div class="tw-flex tw-justify-between tw-text-sm tw-mt-4 ">
                        <div class=""><span class="tw-font-medium">{{ $lang->data['notes'] ?? 'Notes' }} :</span> {{ $order->note }}</div>                        
                    </div>
                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2 tw-mt-4">
                        <div class="tw-w-full tw-h-[1px]  tw-from-transparent tw-to-neutral-300 tw-bg-gradient-to-r"></div>
                        <div class="tw-shrink-0 tw-font-light">{{ $lang->data['powered_by'] ?? 'Powered By' }}<span class="tw-font-bold">{{ getApplicationName() }}</span> </div>
                        <div class="tw-w-full tw-h-[1px] tw-from-transparent tw-to-neutral-300 tw-bg-gradient-to-l"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card h-100 p-0 radius-12 lg:tw-w-[24rem]  tw-w-full tw-shrink-0">
            <div class="card-body p-24">
                @if ($orderaddons)
                    @if (count($orderaddons) > 0)
                    <div class="tw-text-xl tw-font-medium">{{ $lang->data['service_addons'] ?? 'Service Addons' }}</div>
                    @foreach ($orderaddons as $item)
                        <div class="tw-flex tw-flex-col bg-gradient-success card tw-mt-2">
                            <div class="card-body">
                                <div class="tw-flex tw-items-center  tw-text-sm tw-gap-4">
                                    <div class=" tw-relative tw-items-center tw-flex tw-flex-col ">
                                    <iconify-icon icon="tabler:puzzle" class="menu-icon tw-text-xl"></iconify-icon>
                                    </div>
                                    <div class="tw-flex tw-flex-col">
                                        <div class="tw-font-medium">{{ $item->addon_name }} </div>
                                        <div class="">{{ getFormattedCurrency($item->addon_price) }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    @endif
                @endif
                @can('payment_create')
                <div class="tw-text-xl tw-font-medium tw-pt-6">{{ $lang->data['payments'] ?? 'Payments' }}</div>
                @foreach ($payments as $item)
                <div class="tw-flex tw-items-center tw-pt-2 tw-text-sm tw-gap-4">
                    <div class=" tw-relative tw-items-center tw-flex tw-flex-col tw-translate-y-1">
                        <iconify-icon icon="tabler:target" class="menu-icon"></iconify-icon>
                        <div class="tw-top-[100%] tw-left-[6px] tw-h-6 tw-w-[2px] tw-bg-neutral-300"></div>
                    </div>
                    <div class="tw-flex tw-flex-col">
                        <div class="tw-font-medium">{{ getFormattedCurrency($item->received_amount) }}</div>
                        <div class="tw-text-xs tw-font-light tw-mt-1">{{ Carbon\Carbon::parse($item->payment_date)->format('d/m/Y') }} <span class="tw-font-bold">[{{ getpaymentMode($item->payment_type) }}]</span></div>
                    </div>
                </div>
                @endforeach
                @if ($balance > 0)
                    @if($order->status != 4)
                        <button data-bs-toggle="modal" data-bs-target="#exampleModal"  type="button" class="btn btn-outline-success-600 radius-8 px-20 py-11 tw-mt-6 tw-w-full" >{{ $lang->data['add_payment'] ?? 'Add Payment' }}</button>
                    @endif
                @else
                <button type="button" class="btn btn-outline-neutral-600 radius-8 px-20 py-11 tw-mt-6 tw-w-full" disabled>{{ $lang->data['fully_paid'] ?? 'Fully Paid' }}</button>
                @endif
                @endcan
                @can('order_print')
                <a href="{{url('admin/orders/print/'.$order->id)}}" target="_blank" type="button" class="btn btn-outline-warning-600 radius-8 px-20 py-11 tw-mt-3 tw-w-full">{{ $lang->data['print_invoice'] ?? 'Print Invoice' }}</a>
                @endcan()
            </div>
        </div>
    </div>
  

    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-md modal-dialog modal-dialog-centered">
            <div class="modal-content radius-16 bg-base">
                <div class="modal-header py-16 px-24 border border-top-0 border-start-0 border-end-0">
                    <h1 class="modal-title text-md" id="exampleModalLabel">{{ $lang->data['payment_details'] ?? 'Payment Details' }}</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                @if ($order)
                    <div class="modal-body p-24">
                        <form action="#">
                            <div class="row">   
                                <div class="col-12">
                                    <div class="">
                                        <ul>
                                            <li class="d-flex align-items-center gap-1 mb-12 tw-justify-between tw-w-full">
                                                <span class="text-md fw-semibold text-primary-light">{{ $lang->data['customer'] ?? 'Customer' }} :</span>
                                                <span class="text-secondary-light fw-medium">{{ $customer->name ?? '' }}</span>
                                            </li>
                                            <li class="d-flex align-items-center gap-1 mb-12 tw-justify-between ">
                                                <span class="text-md fw-semibold text-primary-light"> {{ $lang->data['order_id'] ?? 'Order ID' }} :</span>
                                                <span class="text-secondary-light fw-medium">{{ $order->order_number }}</span>
                                            </li>
                                            <li class="d-flex align-items-center gap-1 mb-12 tw-justify-between">
                                                <span class="text-md fw-semibold text-primary-light">  {{ $lang->data['order_date'] ?? 'Order Date' }} :</span>
                                                <span class="text-secondary-light fw-medium">{{ \Carbon\Carbon::parse($order->order_date)->format('d/m/Y') }}</span>
                                            </li>
                                            <li class="d-flex align-items-center gap-1 mb-12 tw-justify-between">
                                                <span class="text-md fw-semibold text-primary-light">  {{ $lang->data['delivery_date'] ?? 'Delivery Date' }} :</span>
                                                <span class="text-secondary-light fw-medium">{{ \Carbon\Carbon::parse($order->delivery_date)->format('d/m/Y') }}</span>
                                            </li>
                                            <li class="d-flex align-items-center gap-1 mb-12 tw-justify-between">
                                                <span class="text-md fw-semibold text-primary-light"> {{ $lang->data['order_amount'] ?? 'Order Amount' }} :</span>
                                                <span class="text-secondary-light fw-medium"> {{ getFormattedCurrency($order->total) }}</span>
                                            </li>
                                            <li class="d-flex align-items-center gap-1 mb-12 tw-justify-between">
                                                <span class="text-md fw-semibold text-primary-light"> {{ $lang->data['paid_amount'] ?? 'Paid Amount' }} :</span>
                                                <span class="text-secondary-light fw-medium"> {{ getFormattedCurrency($paid_amount) }}</span>
                                            </li>
                                            <li class="d-flex align-items-center gap-1 tw-justify-between">
                                                <span class="text-md fw-semibold text-primary-light"> {{ $lang->data['balance'] ?? 'Balance' }} :</span>
                                                <span class="text-secondary-light fw-medium"> {{ getFormattedCurrency($order->total - $paid_amount) }}</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-12 tw-my-6">
                                    <hr>
                                </div>
                                    <!-- QRIS Container -->
                                    @if($payment_type == 6)
                                    <div class="row mb-20" wire:key="qris-container">
                                        <div class="col-12 d-flex justify-content-center">
                                            <div class="neumorphic p-4" style="background: #eef2f9; border-radius: 20px; box-shadow: 8px 8px 16px #c8d0e7, -8px -8px 16px #ffffff; width: 300px; text-align: center;"
                                                 x-data
                                                 x-init="$watch('$wire.paid_amount', value => window.generateDynamicQRIS(value)); setTimeout(() => window.generateDynamicQRIS($wire.paid_amount), 200)"
                                            >
                                                <h5 class="text-primary fw-bold mb-3">Scan QRIS</h5>
                                                <div class="neumorphic-inset d-flex align-items-center justify-content-center p-3" style="min-height: 250px; background: #eef2f9; border-radius: 12px; box-shadow: inset 5px 5px 10px #c8d0e7, inset -5px -5px 10px #ffffff;">
                                                    <div id="qrcode"></div>
                                                </div>
                                                <p class="mt-3 fw-bold text-dark" id="display-nominal">Rp {{ number_format($paid_amount, 0, ',', '.') }}</p>
                                                <p class="text-muted text-xs">Arahkan kamera ke QR Code di atas untuk membayar</p>
                                            </div>
                                        </div>
                                    </div>
                                    @endif

                                    @if($payment_type != 6)
                                    <div class="col-12 mb-20 ">
                                        <label for="name" class="form-label fw-semibold text-primary-light text-sm mb-8">{{ $lang->data['paid_amount'] ?? 'Paid Amount' }} <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control radius-8" placeholder="{{ $lang->data['enter_amount'] ?? 'Enter Amount' }}" wire:model="paid_amount" >
                                        @error('balance')
                                            <span class="error text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    @endif
                                <div class="col-12 mb-20 ">
                                    <label for="name" class="form-label fw-semibold text-primary-light text-sm mb-8">{{ $lang->data['payment_type'] ?? 'Payment Type' }} <span class="text-danger">*</span></label>
                                    <select  class="form-select radius-8" wire:model="payment_type">
                                        <option value="">
                                            {{ $lang->data['choose_payment_type'] ?? 'Choose Payment Type' }}
                                        </option>
                                        <option class="select-box" value="1">
                                            {{ $lang->data['cash'] ?? 'Cash' }}
                                        </option>
                                        <option class="select-box" value="2">
                                            {{ $lang->data['upi'] ?? 'UPI' }}
                                        </option>
                                        <option class="select-box" value="3">
                                            {{ $lang->data['card'] ?? 'Card' }}
                                        </option>
                                        <option class="select-box" value="4">
                                            {{ $lang->data['cheque'] ?? 'Cheque' }}
                                        </option>
                                        <option class="select-box" value="5">
                                            {{ $lang->data['bank_transfer'] ?? 'Bank Transfer' }}
                                        </option>
                                        <option class="select-box" value="6">
                                            QRIS
                                        </option>
                                    </select>
                                    <!-- Trigger JS update when select changes or input changes -->
                                    <div x-effect="
                                        if($wire.payment_type == 6) { 
                                            setTimeout(() => window.generateDynamicQRIS($wire.balance), 200);
                                        }
                                    "></div>
                                    @error('payment_type')
                                    <span class="error text-danger">{{ $message }}</span>
                                    @enderror
                                </div>


                                <!-- QRIS Display Section -->
                                <div class="col-12 mb-20" x-show="$wire.payment_type == 6" x-transition>
                                    <div class="d-flex flex-column align-items-center justify-content-center p-3 border radius-8 bg-light">
                                        <h6 class="text-primary-light mb-2">Scan QRIS</h6>
                                        <div id="display-nominal" class="text-lg fw-bold text-primary mb-3"></div>
                                        <div id="qrcode" class="p-2 bg-white radius-8 border"></div>
                                        <p class="text-xs text-muted mt-2">Scan this QR code with your payment app.</p>
                                    </div>
                                    <script>
                                        document.addEventListener('livewire:initialized', () => {
                                            // Watch for payment type changes
                                            Livewire.on('payment_type_changed', (type) => {
                                                console.log('Payment Type changed to:', type);
                                                if(String(type) === '6') {
                                                    setTimeout(() => {
                                                         // Use the balance from Livewire component
                                                        window.generateDynamicQRIS(@this.balance || 0);
                                                    }, 100);
                                                }
                                            });
                                            
                                            // Provide hook for blade to call if needed
                                            window.updateQrisAmount = (amount) => {
                                                 // Ensure only if QRIS is selected
                                                 if(String(@this.payment_type) === '6') {
                                                    window.generateDynamicQRIS(amount);
                                                 }
                                            }
                                        });
                                    </script>
                                </div>
                                <div class="col-12 mb-20">
                                    <label for="name" class="form-label fw-semibold text-primary-light text-sm mb-8">{{ $lang->data['notes'] ?? 'Notes' }} </label>
                                    <textarea class="form-control radius-8" placeholder="{{ $lang->data['enter_notes'] ?? 'Enter Notes' }}"  wire:model="notes"></textarea>
                                    @error('notes')
                                        <span class="error text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="d-flex align-items-start justify-content-end gap-3 mt-24">
                                    <button data-bs-dismiss="modal" type="button" class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-40 py-11 radius-8"> 
                                    {{ $lang->data['cancel'] ?? 'Cancel' }}
                                    </button>
                                    <button wire:click.prevent="addPayment" class="btn btn-primary border border-primary-600 text-md px-24 py-12 radius-8"> 
                                    {{ $lang->data['save'] ?? 'Save' }}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@push('js')
<script src="https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js"></script>
<script>
    // --- CRC16/CCITT-FALSE Calculation Function ---
    function crc16_ccitt_false(data) {
        let crc = 0xFFFF;
        for (let i = 0; i < data.length; i++) {
            crc ^= data.charCodeAt(i) << 8;
            for (let j = 0; j < 8; j++) {
                if ((crc & 0x8000) !== 0) {
                    crc = (crc << 1) ^ 0x1021;
                } else {
                    crc <<= 1;
                }
            }
        }
        return (crc & 0xFFFF).toString(16).toUpperCase().padStart(4, '0');
    }

    window.generateDynamicQRIS = function(amount) {
        if (!amount) amount = 0;
        
        let cleanAmount = String(amount).replace(/,/g, '');
        let numAmount = parseFloat(cleanAmount);
        if (isNaN(numAmount)) numAmount = 0;

        // Format nominal for display (Rp X.XXX.XXX)
        let formattedNominal = new Intl.NumberFormat('id-ID', {
            style: 'currency',
            currency: 'IDR',
            minimumFractionDigits: 0
        }).format(numAmount);
        
        let displayEl = document.getElementById('display-nominal');
        if(displayEl) displayEl.innerText = formattedNominal;

        // Ensure QR container exists
        let qrContainer = document.getElementById("qrcode");
        if (!qrContainer) return;

        // Clear previous QR
        qrContainer.innerHTML = "";

        // Hardcoded static payload (from user provided code)
        // Note: The user snippet has a payload that ends with F93B (CRC). We need to strip it.
        const staticPayload = "00020101021126610014COM.GO-JEK.WWW01189360091436762029880210G6762029880303UMI51440014ID.CO.QRIS.WWW0215ID10254004132540303UMI5204573253033605802ID5912iPhone Haven6013JAKARTA TIMUR61051341062070703A016304F93B";
        
        try {
            // Remove the last 4 chars (CRC) if we are going to recalculate it?? 
            // Actually the logic provided by user finds '6304' tag.
            // Let's use exactly the user's logic.

            const crcTagIndex = staticPayload.lastIndexOf('6304');
            if (crcTagIndex === -1) {
                console.error("Payload tidak valid: Tag CRC '6304' tidak ditemukan.");
                return;
            }

            const basePayload = staticPayload.substring(0, crcTagIndex);
            
            let intAmount = Math.floor(numAmount);
            const amountValue = String(intAmount);
            const amountLength = amountValue.length.toString().padStart(2, '0');
            const amountTag = `54${amountLength}${amountValue}`;
            
            // For now, no tip option in this UI, so we skip tip tag or keep it simple.
            // User code: const tipTag = enableTip ? '550201' : '';
            const tipTag = '';

            const payloadForCrc = `${basePayload}${amountTag}${tipTag}6304`;
            const newCrc = crc16_ccitt_false(payloadForCrc);
            const dynamicPayload = `${payloadForCrc}${newCrc}`;

            new QRCode(qrContainer, {
                text: dynamicPayload,
                width: 200,
                height: 200,
                colorDark : "#2b3d63", 
                colorLight : "#ffffff",
                correctLevel : QRCode.CorrectLevel.M
            });

        } catch (error) {
            console.error(error);
        }
    }
</script>
@endpush