<?php

$database = __DIR__ . '/database/database.sqlite';

if (!file_exists($database)) {
    die("Database file not found at $database\n");
}

try {
    $pdo = new PDO("sqlite:$database");
    // Enable Write-Ahead Logging
    $pdo->exec('PRAGMA journal_mode = WAL;');
    $pdo->exec('PRAGMA synchronous = NORMAL;');
    
    $mode = $pdo->query('PRAGMA journal_mode;')->fetchColumn();
    echo "Database journal mode set to: " . $mode . "\n";
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
