<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\MasterSettings;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    /**
     * Get all master settings for the application.
     */
    public function index()
    {
        $settings = new MasterSettings();
        $siteData = $settings->siteData();

        // Ensure key fields are present even if null
        return response()->json([
            'success' => true,
            'data' => [
                'app_name' => $siteData['default_application_name'] ?? 'Laundry App',
                'currency' => $siteData['default_currency'] ?? 'USD',
                'phone' => $siteData['default_phone_number'] ?? '',
                'email' => $siteData['default_email'] ?? '',
                'address' => $siteData['default_address'] ?? '',
                'tax_number' => $siteData['default_tax_number'] ?? '',
                'tax_percentage' => $siteData['default_tax_percentage'] ?? 10,
                'logo_url' => isset($siteData['default_logo']) ? asset($siteData['default_logo']) : null,
                // Add other necessary fields here
            ]
        ], 200);
    }
}
