<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ServiceType;

class ServiceTypeController extends Controller
{
    public function index()
    {
        $serviceTypes = ServiceType::where('is_active', 1)->get();
        return response()->json([
            'success' => true,
            'data' => $serviceTypes
        ]);
    }

    public function show($id)
    {
        $serviceType = ServiceType::with('serviceDetails.service')->find($id);

        if (!$serviceType) {
            return response()->json([
                'success' => false,
                'message' => 'Service type not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $serviceType
        ]);
    }
}
